/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.slide;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

class SlideWindowSizer
extends MouseAdapter {
    private static final int EDGE_NONE = 0;
    private static final int EDGE_N = 1;
    private static final int EDGE_S = 2;
    private static final int EDGE_E = 3;
    private static final int EDGE_W = 4;
    private static final int EDGE_NE = 5;
    private static final int EDGE_SE = 6;
    private static final int EDGE_SW = 7;
    private static final int EDGE_NW = 8;
    private Component _destination;
    private Component _source;
    private Point _pressed;
    private Point _location;
    private Cursor _originalCursor;
    private Dimension _snapSize = new Dimension(1, 1);
    private int _compStartHeight;
    private int _compStartWidth;
    private boolean _mouseDown = false;

    public void setSource(Component source) {
        if (this._destination == null) {
            this._destination = source;
        }
        this._source = source;
        this._source.addMouseListener(this);
        this._source.addMouseMotionListener(this);
    }

    public void setDestination(Component destination) {
        this._destination = destination;
    }

    public boolean isResizing() {
        return this._mouseDown;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int cursor = e.getComponent().getCursor().getType();
        if (this.isResizeCursor(cursor)) {
            this._compStartHeight = this._destination.getSize().height;
            this._compStartWidth = this._destination.getSize().width;
            this._pressed = e.getLocationOnScreen();
            this._location = this._destination.getLocation();
        }
        this._mouseDown = true;
    }

    private boolean isResizeCursor(int type) {
        switch (type) {
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        e.getComponent().setCursor(this.getCursor(this.getEdge(e)));
    }

    private Cursor getCursor(int edge) {
        switch (edge) {
            case 1: {
                return Cursor.getPredefinedCursor(8);
            }
            case 3: {
                return Cursor.getPredefinedCursor(11);
            }
            case 2: {
                return Cursor.getPredefinedCursor(9);
            }
            case 4: {
                return Cursor.getPredefinedCursor(10);
            }
            case 8: {
                return Cursor.getPredefinedCursor(6);
            }
            case 5: {
                return Cursor.getPredefinedCursor(7);
            }
            case 6: {
                return Cursor.getPredefinedCursor(5);
            }
            case 7: {
                return Cursor.getPredefinedCursor(4);
            }
        }
        return Cursor.getPredefinedCursor(0);
    }

    private int getEdge(MouseEvent e) {
        Insets corners = new Insets(10, 10, 10, 10);
        Insets edges = new Insets(5, 5, 5, 5);
        Point point = e.getPoint();
        Dimension size = e.getComponent().getSize();
        if (point.x < corners.left && point.y < corners.top) {
            return 8;
        }
        if (point.x < corners.left && point.y > size.height - corners.bottom) {
            return 7;
        }
        if (point.x > size.width - corners.right && point.y < corners.top) {
            return 5;
        }
        if (point.x > size.width - corners.right && point.y > size.height - corners.bottom) {
            return 6;
        }
        if (point.y < edges.top) {
            return 1;
        }
        if (point.x > size.width - edges.right) {
            return 3;
        }
        if (point.y > size.height - edges.bottom) {
            return 2;
        }
        if (point.x < edges.left) {
            return 4;
        }
        return 0;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        Component component = e.getComponent();
        int cursor = component.getCursor().getType();
        Point dragged = e.getLocationOnScreen();
        int dragX = this.getDragDistance(dragged.x, this._pressed.x, this._snapSize.width);
        int dragY = this.getDragDistance(dragged.y, this._pressed.y, this._snapSize.height);
        int nextWidth = this._compStartWidth;
        int nextHeight = this._compStartHeight;
        int nextX = this._location.x;
        int nextY = this._location.y;
        switch (cursor) {
            case 8: {
                nextHeight -= dragY;
                nextY += dragY;
                break;
            }
            case 11: {
                nextWidth += dragX;
                break;
            }
            case 9: {
                nextHeight += dragY;
                break;
            }
            case 10: {
                nextWidth -= dragX;
                nextX += dragX;
                break;
            }
            case 5: {
                nextWidth += dragX;
                nextHeight += dragY;
                break;
            }
            case 4: {
                nextWidth -= dragX;
                nextHeight += dragY;
                nextX += dragX;
                break;
            }
            case 7: {
                nextWidth += dragX;
                nextHeight -= dragY;
                nextY += dragY;
                break;
            }
            case 6: {
                nextWidth -= dragX;
                nextHeight -= dragY;
                nextY += dragY;
                nextX += dragX;
                break;
            }
        }
        this._destination.setLocation(nextX, nextY);
        if (this.isResizeCursor(cursor)) {
            this._destination.setSize(nextWidth, nextHeight);
            this._destination.validate();
            this._destination.repaint();
        }
    }

    private int getDragDistance(int larger, int smaller, int snapSize) {
        int drag;
        int halfway = snapSize / 2;
        drag += (drag = larger - smaller) < 0 ? -halfway : halfway;
        drag = drag / snapSize * snapSize;
        return drag;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this._source != null) {
            this._source.setCursor(this._originalCursor);
        }
        this._mouseDown = false;
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (!this._mouseDown) {
            e.getComponent().setCursor(this.getCursor(0));
        }
    }
}

