/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.archive.mtz;

import com.paterva.maltego.archive.mtz.Entry;
import com.paterva.maltego.archive.mtz.EntryFactory;
import com.paterva.maltego.archive.mtz.MaltegoArchive;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.io.ZipInputStream;

public class MaltegoArchiveReader {
    private final MaltegoArchive _archive;

    public MaltegoArchiveReader(ZipFile file) {
        this._archive = new MaltegoArchive(file);
    }

    public <T> T read(Entry<T> entry) throws IOException {
        ZipInputStream is = null;
        try {
            if (!this._archive.containsEntry(entry.getName())) {
                T t = null;
                return t;
            }
            is = this._archive.getInputStream(entry.getName());
            T t = entry.read((InputStream)is);
            return t;
        }
        catch (ZipException ex) {
            throw new IOException(ex);
        }
        finally {
            if (is != null) {
                is.close(true);
            }
        }
    }

    public <T, TEntry extends Entry<T>> List<T> readAll(EntryFactory<TEntry> factory, String graphName) throws IOException {
        ArrayList<T> list = new ArrayList<T>();
        try {
            List<TEntry> entries = this._archive.createEntries(factory, graphName);
            for (Entry entry : entries) {
                T obj = this.read(entry);
                if (obj == null) continue;
                list.add(obj);
            }
        }
        catch (ZipException ex) {
            throw new IOException(ex);
        }
        return list;
    }
}

