/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.ui.wizard;

import com.paterva.maltego.graph.table.ui.wizard.IndexPainter;
import com.paterva.maltego.graph.table.ui.wizard.SampleHeader;
import com.paterva.maltego.util.ui.table.IconTextHeaderRenderer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import javax.swing.JTable;

public class SampleHeaderRendererRotated
extends IconTextHeaderRenderer {
    private int _entityNum = -1;
    private boolean needsRotate;
    private LabelDirection labelDirection;

    public SampleHeaderRendererRotated() {
        this.setDirection(LabelDirection.HORIZONTAL);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (value instanceof SampleHeader) {
            SampleHeader sampleHeader = (SampleHeader)((Object)value);
            this._entityNum = sampleHeader.entityNum;
        } else {
            this._entityNum = -1;
        }
        this.setHorizontalAlignment(2);
        return this;
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this._entityNum > 0) {
            int yPos = 30;
            if (this.getDirection() == LabelDirection.VERTICAL_UP) {
                yPos = this.getSize().height - 2;
            }
            IndexPainter.paint(g, this._entityNum, this.getFont(), 5, yPos);
        }
    }

    public LabelDirection getDirection() {
        return this.labelDirection;
    }

    public void setDirection(LabelDirection direction) {
        this.labelDirection = direction;
    }

    public Dimension getPreferredSize() {
        Dimension preferredSize = super.getPreferredSize();
        switch (this.getDirection()) {
            case VERTICAL_UP: 
            case VERTICAL_DOWN: {
                int extraHeight = this.getIcon() != null ? this.getIcon().getIconWidth() + this.getIconTextGap() + 6 : 0;
                return new Dimension(preferredSize.height, preferredSize.width + extraHeight);
            }
        }
        return preferredSize;
    }

    public Dimension getSize() {
        if (!this.needsRotate) {
            return super.getSize();
        }
        Dimension size = super.getSize();
        switch (this.getDirection()) {
            case VERTICAL_UP: 
            case VERTICAL_DOWN: {
                return new Dimension(size.height, size.width);
            }
        }
        return super.getSize();
    }

    public int getHeight() {
        return this.getSize().height;
    }

    public int getWidth() {
        return this.getSize().width;
    }

    protected void paintComponent(Graphics g) {
        Graphics2D gr = (Graphics2D)g.create();
        switch (this.getDirection()) {
            case VERTICAL_UP: {
                gr.translate(0.0, this.getSize().getHeight());
                gr.transform(AffineTransform.getQuadrantRotateInstance(-1));
                break;
            }
            case VERTICAL_DOWN: {
                gr.transform(AffineTransform.getQuadrantRotateInstance(1));
                gr.translate(0.0, -this.getSize().getWidth());
                break;
            }
        }
        this.needsRotate = true;
        super.paintComponent((Graphics)gr);
        this.needsRotate = false;
    }

    public static enum LabelDirection {
        HORIZONTAL,
        VERTICAL_UP,
        VERTICAL_DOWN;

    }
}

