/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.treelist.lazy.filter;

import com.bulenkov.darcula.ui.DarculaTextFieldUICallback;
import com.paterva.maltego.treelist.lazy.LazyTreelistSettings;
import com.paterva.maltego.treelist.lazy.outline.LazyOutline;
import com.paterva.maltego.util.ui.WindowUtil;
import java.awt.BorderLayout;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class LazyOutlineFilterPanel
extends JPanel {
    private final LazyOutline _outline;
    private final JTextField _textField = new JTextField();
    private final DarculaTextFieldUICallback _fieldCallBack = new DarculaTextFieldUICallbackImpl();

    public LazyOutlineFilterPanel(LazyOutline outline, boolean small) {
        this._outline = outline;
        this.setLayout(new BorderLayout());
        this._textField.putClientProperty("JTextField.variant", "search");
        this._textField.putClientProperty("JTextField.Search.SearchType", "progressiveTimer");
        this._fieldCallBack.setFilterDelay(200);
        this._textField.putClientProperty("JTextField.Search.ProgressiveTimer.Callback", this._fieldCallBack);
        if (small) {
            this._textField.putClientProperty("JTextField.small", Boolean.TRUE);
            this._textField.setFont(this.getFont().deriveFont(LazyTreelistSettings.getDefault().getTableFontSize(small)));
            this._textField.getDocument().putProperty("i18n", Boolean.TRUE);
        }
        this.add(this._textField);
    }

    public void setText(String text) {
        this._textField.setText(text);
    }

    private class DarculaTextFieldUICallbackImpl
    extends DarculaTextFieldUICallback {
        private DarculaTextFieldUICallbackImpl() {
        }

        public void perform() {
            try {
                WindowUtil.showWaitCursor();
                String filterText = LazyOutlineFilterPanel.this._textField.getText();
                LazyOutlineFilterPanel.this._outline.setFilterText(filterText);
            }
            finally {
                WindowUtil.hideWaitCursor();
            }
        }
    }
}

