/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb.client;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.IHttpExchange;
import org.xlightweb.IHttpRequest;
import org.xlightweb.IHttpRequestHandler;
import org.xlightweb.IHttpResponse;
import org.xlightweb.IHttpResponseHandler;
import org.xlightweb.client.CookieManager;
import org.xsocket.Execution;
import org.xsocket.ILifeCycle;

final class CookieHandler
implements IHttpRequestHandler,
ILifeCycle {
    private static final Logger LOG = Logger.getLogger(CookieHandler.class.getName());
    private static final String COOKIE_WARNING_KEY = "org.xlightweb.client.cookieHandler.cookieWarning";
    private final CookieManager cookieManager = new CookieManager();

    CookieHandler() {
    }

    public void onInit() {
    }

    public void onDestroy() throws IOException {
        this.cookieManager.close();
    }

    @Execution(value=0)
    public void onRequest(final IHttpExchange exchange) throws IOException {
        IHttpRequest request;
        IHttpResponseHandler respHdl;
        block5: {
            respHdl = new IHttpResponseHandler(){

                @Execution(value=0)
                public void onResponse(IHttpResponse response) throws IOException {
                    block3: {
                        HashMap<String, List<String>> responseHeaders = new HashMap<String, List<String>>();
                        for (String headername : response.getHeaderNameSet()) {
                            responseHeaders.put(headername, response.getHeaderList(headername));
                        }
                        try {
                            CookieHandler.this.cookieManager.put(CookieHandler.this.getRequestURI(exchange), responseHeaders);
                        }
                        catch (URISyntaxException ue) {
                            if (!LOG.isLoggable(Level.FINE)) break block3;
                            LOG.fine("invcalid URI. ignore handling cookies " + ue.toString());
                        }
                    }
                    exchange.send(response);
                }

                public void onException(IOException ioe) throws IOException {
                    exchange.sendError(ioe);
                }
            };
            request = exchange.getRequest();
            try {
                Map<String, List<String>> cookieHeaders = this.cookieManager.get(this.getRequestURI(exchange));
                for (Map.Entry<String, List<String>> entry : cookieHeaders.entrySet()) {
                    if (entry.getValue().isEmpty()) continue;
                    StringBuilder sb = new StringBuilder();
                    List<String> cookies = entry.getValue();
                    for (int i = 0; i < cookies.size(); ++i) {
                        sb.append(cookies.get(i));
                        if (i + 1 >= cookies.size()) continue;
                        sb.append("; ");
                    }
                    if (request.getHeader("Cookie") != null && Boolean.parseBoolean(System.getProperty(COOKIE_WARNING_KEY, "true"))) {
                        LOG.warning("cookie is set manually and auto handle cookie is activate (hint: deactivate auto handling cookie by calling <httpClient>.setAutoHandleCookies(false) or suppress this message by setting system property 'org.xlightweb.client.cookieHandler.cookieWarning=false')");
                    }
                    request.addHeader(entry.getKey(), sb.toString());
                }
            }
            catch (URISyntaxException ue) {
                if (!LOG.isLoggable(Level.FINE)) break block5;
                LOG.fine("invcalid URI. ignore handling cookies " + ue.toString());
            }
        }
        exchange.forward(request, respHdl);
    }

    private URI getRequestURI(IHttpExchange exchange) throws URISyntaxException {
        return exchange.getRequest().getRequestUrl().toURI();
    }
}

