/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.cache;

import com.paterva.maltego.graph.cache.CachedItems;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FifoCache<K, V> {
    private static final Logger LOG = Logger.getLogger(FifoCache.class.getName());
    private final String _name;
    private final int _capacity;
    private final Map<K, V> _cachedItems = new HashMap();
    private final Queue<K> _keyQueue = new LinkedList<K>();
    private int _puts = 0;
    private int _new = 0;
    private int _hits = 0;
    private int _misses = 0;
    private int _trimmed = 0;
    private int _removes = 0;
    private int _clears = 0;
    private Timer _logTimer = null;

    public FifoCache(String name, int capacity) {
        this._name = name;
        this._capacity = capacity;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "{0} capacity: {1}", new Object[]{this._name, capacity});
        }
    }

    public int getCapacity() {
        return this._capacity;
    }

    public synchronized void put(K key, V value) {
        int size = this._cachedItems.size();
        this._cachedItems.put(key, value);
        ++this._puts;
        if (size != this._cachedItems.size()) {
            ++this._new;
            this._keyQueue.add(key);
            if (this._keyQueue.size() > this._capacity) {
                K removedKey = this._keyQueue.remove();
                this._cachedItems.remove(removedKey);
                ++this._trimmed;
            }
            this.scheduleLogStats();
        }
    }

    public synchronized V get(K key) {
        V value = this._cachedItems.get(key);
        if (value != null || this._cachedItems.containsKey(key)) {
            ++this._hits;
        } else {
            ++this._misses;
        }
        this.scheduleLogStats();
        return value;
    }

    public synchronized V remove(K key) {
        V removed = null;
        if (this._cachedItems.containsKey(key)) {
            removed = this._cachedItems.remove(key);
            this._keyQueue.remove(key);
            ++this._removes;
        }
        return removed;
    }

    public synchronized void remove(Collection<K> keys) {
        int size = this._keyQueue.size();
        this._cachedItems.keySet().removeAll(keys);
        this._keyQueue.removeAll(keys);
        this._removes += size - this._keyQueue.size();
    }

    public synchronized CachedItems<K, V> get(Collection<K> keys) {
        HashMap<K, V> items = new HashMap<K, V>();
        HashSet<K> missedKeys = new HashSet<K>();
        for (K key : keys) {
            if (this._cachedItems.containsKey(key)) {
                V value = this._cachedItems.get(key);
                items.put(key, value);
                ++this._hits;
                continue;
            }
            missedKeys.add(key);
            ++this._misses;
        }
        this.scheduleLogStats();
        return new CachedItems(items, missedKeys);
    }

    public synchronized boolean contains(K key) {
        return this._cachedItems.containsKey(key);
    }

    public synchronized boolean containsAll(Collection<K> keys) {
        return this._cachedItems.keySet().containsAll(keys);
    }

    public synchronized void clear() {
        this._cachedItems.clear();
        this._keyQueue.clear();
        ++this._clears;
    }

    private synchronized void scheduleLogStats() {
        if (LOG.isLoggable(Level.FINE) && this._logTimer == null) {
            this._logTimer = new Timer("FiFo Log");
            this._logTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    FifoCache.this.logStats();
                }
            }, 1000L);
        }
    }

    private synchronized void logStats() {
        LOG.log(Level.FINE, "{0} {1} puts:{2} new:{3} hits:{4} misses:{5} trimmed:{6} removes:{7} clears:{8} size:{9}", new Object[]{new Date(), this._name, this._puts, this._new, this._hits, this._misses, this._trimmed, this._removes, this._clears, this._keyQueue.size()});
        this._puts = 0;
        this._new = 0;
        this._hits = 0;
        this._misses = 0;
        this._trimmed = 0;
        this._removes = 0;
        this._clears = 0;
        this._logTimer = null;
    }
}

